/*------------------------------------------------------------------------------*
 * File Name: oFilterUtils.h 													*
 * Creation: 																	*
 * Purpose:  functions for working with filters									*
 * Copyright (c)2006 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _OFILTERUTILS_H
#define _OFILTERUTILS_H

#define MOVE_TREE_UTILS


#ifdef __AFX_H__
	#ifndef OKUTIL_AS_EXTDLL
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$we are NOT in okutil, but some other DLL")
	#else
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$we are in okutil")
	#endif

	#define OC_API			OKUTIL_EXPORT_IMPORT
	#define	string			CString
	#define	StringArray		CScriptMocaObject
	#define	IntArray		CScriptMocaObject
	#define TreeNode		OCXmlWrapperBase
	#define	PointArray		CScriptMocaObject
	#define DoubleArray		CScriptMocaObject
	extern "C" {
		#pragma message("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$extern C in outils.h")
#else
	#define OC_API
	#define	PointArray		vector<point>
	#define	IntArray	vector<int>
	#define DoubleArray vector<double>
	#pragma dll(okUtil80)	// Associate all functions below to okUtil80.dll which must be in the Origin EXE folder
#endif //__AFX_H__

#ifndef MOVE_TREE_UTILS//Hong 8/24/06 MOVE_OFILTER_UTILS_TO_TREE_UTILS
OC_API int fuGetInt(TreeNode *tnFilter, int nID, int nDefault = 0);
OC_API BOOL fuSetInt(TreeNode *tnFilter, int nID, int nValue);

OC_API double fuGetDouble(TreeNode *tnFilter, int nID, double dDefault = 0.0);
OC_API BOOL fuSetDouble(TreeNode *tnFilter, int nID, double dValue);

OC_API BOOL fuGetStr(TreeNode *tnFilter, int nID, string* strValue);
OC_API BOOL fuSetStr(TreeNode *tnFilter, int nID, LPCSTR lpcstrValue);

OC_API BOOL fuGetFlag(TreeNode *tnFilter, DWORD dwFlag, BOOL bDefault = FALSE);
OC_API BOOL fuSetFlag(TreeNode *tnFilter, DWORD dwFlag, BOOL bSet = TRUE);

OC_API int fuGetTargetPage(TreeNode *tnFilter, string *strTemplate = NULL);
OC_API BOOL fuSetTargetPage(TreeNode *tnFilter, int nType, LPCSTR lpcszTemplate = NULL);


#ifdef __AFX_H__
	}
#endif //__AFX_H__
///Hong 8/24/06 MOVE_OFILTER_UTILS_TO_TREE_UTILS
#else  //MOVE_TREE_UTILS
///---Sim 08-30-2006 REMOVE_TO_FU_UTILS
//OC_API int fuGetTargetPage(TreeNode *tnFilter, string *strTemplate = NULL);
//OC_API BOOL fuSetTargetPage(TreeNode *tnFilter, int nType, LPCSTR lpcszTemplate = NULL);
///---END REMOVE_TO_FU_UTILS


#ifdef __AFX_H__
	}
#endif //__AFX_H__

///---Sim 08-29-2006 SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetRInt(_tnFilter, _nID, _nValue) tree_getr_int_value_by_id(_tnFilter, _nID, _nValue)
///---END SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetInt(_tnFilter, _nID, _nDefault) tree_get_int_value_by_id(_tnFilter, _nID, _nDefault)
#define fuSetInt(_tnFilter, _nID, _nValue) tree_set_int_value_by_id(_tnFilter, _nID, _nValue)

///---Sim 08-29-2006 SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetRDouble(_tnFilter, _nID, _dValue) tree_getr_double_value_by_id(_tnFilter, _nID, _dValue)
///---END SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetDouble(_tnFilter, _nID, _dDefault) tree_get_double_value_by_id(_tnFilter, _nID, _dDefault)
#define fuSetDouble(_tnFilter, _nID, _dValue) tree_set_double_value_by_id(_tnFilter, _nID, _dValue)

///---Sim 08-29-2006 SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetRStr(_tnFilter, _nID, _strValue) tree_getr_string_value_by_id(_tnFilter, _nID, _strValue)
///---END SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetStr(_tnFilter, _nID, _strDefault) tree_get_string_value_by_id(_tnFilter, _nID, _strDefault)
#define fuSetStr(_tnFilter, _nID, _strValue) tree_set_string_value_by_id(_tnFilter, _nID, _strValue)

///---Sim 08-29-2006 SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetRFlag(_tnFilter, _nID, _bValue) tree_getr_flag_value_by_id(_tnFilter, _nID, _bValue)
///---END SUPPORT_GET_VALUE_USE_REFERENCE
#define fuGetFlag(_tnFilter, _nID, _bDefault) tree_get_flag_value_by_id(_tnFilter, _nID, _bDefault)
#define fuSetFlag(_tnFilter, _nID, _bValue) tree_set_flag_value_by_id(_tnFilter, _nID, _bValue)
#endif //MOVE_TREE_UTILS
///end MOVE_OFILTER_UTILS_TO_TREE_UTILS

#endif // _OFILTERUTILS_H
